ComboFx = copy_table(BaseObject)


function ComboFx:init(def, view)
    self.view = view
    self.enabled = true

    self.time = 0
    self.total_time = def.total_time
    self.looped = def.looped

    self.x = def.x
    self.y = def.y
    self.z = def.z

    self.objects = {}

    local o
    local z = 0

    for k,v in pairs(def.objects) do
        o = view:create_and_add_object(v, false)
        o.x = self.x + (o.x or 0)
        o.y = self.y + (o.y or 0)
        o.z = self.z + (o.z or z)
        z = z + 1
        table.insert(self.objects, o)
    end

    view:sort_objects()
end


function ComboFx:destroy()
    self:destroy_children()
end


function ComboFx:destroy_children()
    if self.objects then
        for i,o in ipairs(self.objects) do
            o.to_destroy = true
        end
        self.objects = nil
    end
end


function ComboFx:update(dt)
    self.time = self.time + dt
    
    if self.time >= self.total_time then
        if self.looped then
            self.time = 0
            for i,o in ipairs(self.objects) do
                if o.restart then o:restart() end
            end
        else
            self.to_destroy = true
            self:destroy_children()
        end
    end
end


function ComboFx:render()
end

----------------------------------------------------------------------

ComboFxCache = {}

function load_combo_fx(definition)
    local def
    if type(definition) == "string" then
        if ComboFxCache[definition] then
            def = copy_table(ComboFxCache[definition])
            --log("combo_fx "..definition.." loaded from cache")
        else
            def = file_load_lua_table("combo_fx/"..definition..".lua")
            ComboFxCache[definition] = def
            --log("combo_fx "..definition.." loaded from disk")
        end
    else
        def = definition
    end
    return def
end


function create_combo_fx(view, definition, start_x, start_y, start_z)
    local def = load_combo_fx(definition)
    if start_x then def.x = start_x end
    if start_y then def.y = start_y end
    if start_z then def.z = start_z end
    return view:create_and_add_object(def)
end
